# Control file for tide2idx

# The TOO_FAR_NM variable sets the threshold for the "Warning: Large move"
#     message generated when testing substation positions with the
#     corresponding reference station. Units are in NM (about 1.2 Statute Miles)
TOO_FAR_NM 2000

# The CLEAN_INDEX_FILE variable when present, generates a smaller (and faster
# loading) index file with error messages. Error messages are still sent to screen.
CLEAN_INDEX_FILE

# The DISPLAY_FIXUP variable when present, outputs an information message for all
# region fixups.  (Only used for testing)
#DISPLAY_FIXUP

REF_STATION_LIST
# This is the place where we correlate short (abbreviated) reference station
# names with actual reference station names as they appear in the Harmonics file.
#
# Field 1: Short name for reference station (no blanks)
# Rest of line: Reference station name Exactly as it appears
# Note: Some abbreviations are (almost) duplicates to correct misspellings in the
#      original subordiante station list files.

aberdeen Aberdeen, Washington
acapulco Acapulco, Guerrero, Mexico
adelaide Adelaide Inner Harbour, Australia
aden     Aden, Yemen
amoy     Xiamen, China
amuay    Amuay, Venezuela
anchrage Anchorage, Alaska
antofag  Antofagasta, Chile
antwerp  Antwerpen, Belgium
apia     Apia, Samoa Islands
argentia Argentia, Newfoundland
astoria  Astoria (Tongue Point), Oregon
auckland Auckland, New Zealand
auchland Auckland, New Zealand
bahiala  Bahia de los Angeles, Baja California Norte, Mexico
balboa   Balboa, Panama
ballenas Bahia de Ballenas, Baja California Sur, Mexico
baltmore Baltimore (Fort McHenry), Maryland
bangkok  Bangkok, Thailand
barito   Sungai Barito, Borneo, Indonesia
beira    Beira, Mozambique
belawan  Belawan, Sumatra, Indonesia
bergen   Bergen, Norway
bombay   Bombay, India
boston   Boston, Massachusetts
brdgport Bridgeport, Connecticut
bremhavn Bremerhaven, Germany
brest    Brest, France
brisbane Brisbane Bar, Australia
brkwater Breakwater Harbor, Delaware
buaires  Buenos Aires, Argentina
bventura Buenaventura, Colombia
callao   Callao, Peru
campeche Campeche City, Campeche, Mexico
capetown Cape Town, South Africa
casblnca Casablanca, Morocco
cebu     Cebu, Philippines
#ch'ang
cherburg Cherbourg, France
chi-lung Chi-Lung, Taiwan
chrston  Charleston, South Carolina
chrlston Charleston, South Carolina
colombo  Colombo, Sri Lanka
cordova  Cordova, Alaska
crstobal Cristbal, Panama
cuxhaven Cuxhaven, Germany
dairenko Daliang, China
dakar    Dakar, Senegal
darsalam Dar Es Salaam, Tanzania
darwin   Darwin, Australia
davao    Davao, Philippines
djakarta Tanjung Priok, Java, Indonesia
doson    Do Son, Vietnam
dover    Dover, England - READ flaterco.com/pol.html
dreger   Dreger Harbour, Papua New Guinea
#dublin   Dublin, Ireland
dublon   Dublon Island, Chuuk, F.S.M.
durban   Durban, South Africa
dutchhbr Unalaska, Alaska
eastprt  Eastport, Maine
eastport Eastport, Maine
ensenada Ensenada, Baja California Norte, Mexico
esbjerg  Esbjerg, Denmark
fernando San Fernando, Philippines
frisco   San Francisco, California
Galvstn  Galveston (Galveston Channel), Texas
galvston Galveston (Galveston Channel), Texas
gibraltr Gibraltar
gibraltar Gibraltar
#greenock Greenock, Scotland
guam     Guam, Marianas
guaymas  Guaymas, Sonora, Mexico
guayquil Guayaquil, Ecuador
halifax  Halifax, Nova Scotia
hamburg  Hamburg, Germany
hampton  Hampton Roads, Virginia
haringtn Harrington Harbour, Qubec
hedland  Port Hedland, Australia
helgolnd Helgoland, Germany
hobart   Hobart, Tasmania
hoek-hol Hoek van Holland, Netherlands
hongkong Hong Kong, China
honolulu Honolulu, Oahu (Hawaii)
hornos   Orange Bay, Chile
humboldt Humboldt Bay, North Spit, California
ilguadal Isla Guadalupe, Baja California Norte, Mexico
ilsocoro Isla Socorro, Revillagigedo Islands, Mexico
imingham Immingham, England - READ flaterco.com/pol.html
inch'on  Inch'on, South Korea
#ingwhite
jolo     Jolo, Philippines
juanico  Bahia San Juanico, Baja California Sur, Mexico
juneau   Juneau, Alaska
kamaisi  Kamaisi, Iwate, Japan
karachi  Karachi, Pakistan
kem      Port Kem, Russia
ketchkan Ketchikan, Alaska
ketckan  Ketchikan, Alaska
keywest  Key West (Naval Base), Florida
kobe     Kobe, Hyogo, Japan
kodiak   Kodiak, Women's Bay, Alaska
kure     Kure, Japan
kutei    Sungai Kutei, Borneo, Indonesia
kwajalin Kwajalein Atoll, Marshall Islands
la-union La Union, El Salvador
lapaz    La Paz, Baja California Sur, Mexico
laz-card Cardenas (Melchor Ocampo), Mexico
legaspi  Legaspi, Philippines
lehavre  Le Havre, France
leith    Leith, Scotland - READ flaterco.com/pol.html
lincoln  Port Lincoln, Australia
lisboa   Lisbon, Portugal
livrpool Liverpool (Gladstone Dock), England - READ flaterco.com/pol.html
#london   London Bridge, England
losangel Los Angeles, California
ma-kung  Makung, China
madras   Madras, India
magdbay  Bahia Magdalena, Baja California Sur, Mexico
malakal  Malakal Harbor, Palau Islands, Caroline Islands
manila   Manila, Philippines
manzillo Manzanillo, Colima, Mexico
masscreb Massacre Bay, Attu Island, Alaska
matarani Matarani, Peru
mayport  Mayport (ferry dock), Florida
mazatlan Mazatln, Sinaloa, Mexico
mergui   Mergui, Myanmar
miami    Miami Harbor Entrance, Florida
mobile   Mobile (Mobile State Docks), Alabama
mokuoloe Moku o Loe Island, Oahu (Hawaii)
monterey Monterey Harbor
muivung  Vung Tau, Vietnam
musi     Air Musi, Sumatra, Indonesia
naha     Naha, Okinawa, Japan
namp'o   Chinnampo, North Korea
narvik   Narvik, Norway
newlondn New London, Connecticut
newport  Newport, Rhode Island
newyork  New York, New York
nikishka Nikiski, Cook Inlet, Alaska
nushagak Nushagak Bay (Clark's Point), Alaska
#oban     Oban, Scotland
otomari  Korsakov, Russia
paramusr Zaliv Tukharka, Kurile Islands
parsonsb Parsons Bay, Tasmania
pei-hai  Pei-Hai, China
penasco  Puerto Penasco, Sonora, Mexico
penscola Pensacola, Florida
philadel Philadelphia, Pennsylvania
phillip  Port Phillip Heads, Australia
pictou   Pictou, Nova Scotia
ponape   Ponape Harbor, Caroline Islands
porland  Portland, Maine
portland Portland, Maine
pt-montt Puerto Montt, Chile
ptangel  Puerto Angel, Oaxaca, Mexico
ptarenas Puntarenas, Costa Rica
ptdlgada Ponta Delgada, Sao Miguel, Azores
ptegrave Pointe de Grave, France
ptgorda  Punta Gorda, Venezuela
ptloyola Puerto Gallegos, Argentina
ptvallar Puerto Vallarta, Jalisco, Mexico
puarenas Punta Arenas, Chile
pusan    Pusan, South Korea
quebec   Qubec (Lauzon), Qubec
rangoon  Rangoon River, Myanmar
recife   Recife, Brazil
reedypt  Reedy Point, Delaware
reykjvik Reykjavik, Iceland
riodejan Rio de Janeiro, Brazil
#rngaskdy Cobh, Ireland
rvadavia Comodoro Rivadavia, Argentina
s-diego  San Diego, California
sagar    Sagar Island, India
sakate   Sakate (Syodo Sima), Kagawa, Japan
sal-cruz Salina Cruz, Oaxaca, Mexico
salman   Mina Salman, Bahrain
sanjuan  San Juan, Puerto Rico
sanlucas Cabo San Lucas, Baja California Sur, Mexico
sanluis  Port San Luis, California
santos   Santos, Brazil
savanah  Savannah (Bull Street), Georgia
savannah Savannah River Entrance, Georgia
scarlsbc San Carlos, Baja California Sur, Mexico
seattle  Seattle, Washington
seldovia Seldovia, Alaska
sfax     Sfax, Tunisia
shanghai Shanghai, China
shatarab Shaat al Arab, Iraq
sheernss Sheerness, England - READ flaterco.com/pol.html
shimseki Simonoseki Sanbasi, Yamaguti, Japan
singapor Singapore (Victoria Dock)
sitka    Sitka, Alaska
sndyhook Sandy Hook, New Jersey
#southmpt Southampton, England
stjohn   Saint John, New Brunswick
stmarks  St. Marks River Entrance, Florida
stmichel St. Michael, Alaska
stpete   St. Petersburg, Florida
stthomas Saint Thomas, Saint Thomas
suez     Suez, Egypt
surabaja Karang Jamuang, Java, Indonesia
suriname Surinam River, Surinam
swatow   Swatow, China
sweeperc Sweeper Cove, Adak Island, Alaska
sydney   Sydney, Australia
takoradi Takoradi, Ghana
talara   Talara, Peru
tampico  Tampico, Tamaulipas, Mexico
tannurah Ra's al Qulay`ah, Saudi Arabia
tientsin Tianjin Xingang, China
topolbpo Topolobampo, Sinaloa, Mexico
townsend Port Townsend, Washington
townsvil Townsville, Australia
ullapool Ullapool, Scotland - READ flaterco.com/pol.html
valdez   Valdez, Alaska
vancouvr Vancouver, British Columbia
venezia  Venezia, Italy
veracruz Veracruz City, Veracruz, Mexico
victoria Victoria, British Columbia
vlissngn Vlissingen, Netherlands
vparaiso Valparaiso, Chile
washngtn Washington, D.C.
weihaiwe Wei-Hai-Wei, China
wellngtn Wellington, New Zealand
willetsp Willets Point, New York
wilmngtn Wilmington, North Carolina
yamato   Ostrov Toporkova, Kuril Islands, Russia
yavaros  Yavaros, Sonora, Mexico
yekateri Yekaterininskaya, Russia
yokohama Yokohama-Sinko, Kanagawa, Japan
zapara   Malecon, Venezuela
*END*

REGION_COUNTRY_STATE_LIST
# This group of assignments lets us assign states to countries and countries
# to regions.  This is used for error checking as well as allowing us to sort
# stations by region:country:state.
# For those cases where a state, or a country w/o a state, lies on two bodies of
# water, i.e. Florida, Atlantic or Gulf, a special REGION_FIXUP assignment set
# is used (see last major section).
#
# Field 1: REGION for COUNTRY/STATE
# Field 2: Abbreviation of COUNTRY
# Field 3: Abbreviation of STATE (optional)
# Note: No end-of-line comments are allowed!
NAA US ME
NAA US NH
NAA US MA
NAA US CT
NAA US RI
NAA US NY
NAA US NJ
NAA US DE
NAA US PA
NAA US MD
NAA US DC
NAA US VA
NAA US NC
NAA US SC
NAA US GA
NAA US FL
NAG US AL
NAG US MS
NAG US LA
NAG US TX
NAP US CA
NAP US WA
NAP US OR
NAP US AK
Pac US HI

Med Alb
Med Alg
Afr Ang
Ant Ant
Car Antg
Arb Arab
SAA Arg
Med AsiM
AuA Aus
Atl Azor
Car Bahm
Arb Bahr
Ind Bngl
Car Barb
Eur Belg
CAC Belz
Atl Berm
Pac Bsmk
Car Bona
SAA Brz
Ind Burm
Atl CVrd
Car Caic
SEA Camb
Afr Came
NAP Can BC
NAA Can Labr
NAA Can Man
#NAA Can Marit
NAA Can NWT
NAA Can Newb
NAA Can Newf
NAA Can Nun
NAA Can NovS
NAA Can Ont
NAA Can Qbc
Atl Canr
Pac Carl
Asi Chin
SAP Chl
Ind Chrs
Ind Coco
SAC Col
Afr Cong
Pac Cook
CAC CosR
Med Croa
Car Cuba
Car Cura
Med Cyp
Eur Den
Afr Djib
Car Domi
Car DomR
Pac Estr
SAP Ecu
Afr Egy
Pac Ell
CAP ElSa
Eur Eng
Arb Erit
Atl Faer
Atl Falk
Pac Fann
Pac Fiji
Eur Fr
SAC FrGu
Afr Gabn
Pac Galp
Afr Gamb
Eur Ger
Afr Ghan
Eur Gibr
Pac Gilb
Med Grc
Car Gren
Atl Grn
Car Grnd
Car Guad
Pac Guam
CAC Guat
Afr Guin
Afr GuinB
SAC Guya
Asi HK
Car Hait
CAC Hond
Pac Howl
Atl Icel
Ind Indi
SEA Indo
Arb Iran
Arb Iraq
Eur Ire
Med Isr
Med Itl
Afr Ivor
Car Jam
Pac Jons
Asi Jpn
Afr Keny
Asi Kir
Asi Kor
Arb Kuat
Pac Lays
Med Leb
Afr Leon
Afr Libe
Pac Loy
Med Lyb
Ind Mada
Atl Made
SEA Mal
Pac Micr
Med Malt
Pac Mari
Pac Marq
Pac Mars
Car Mart
Afr Maur
NAP Mex BCS
#NAP Mex Col
#NAP Mex Jal
#NAP Mex Sin
#NAP Mex Son
Pac Midw
Med Mona
Afr Mor
Afr Moza
Ind Mymr
Pac NewC
AuA NZ
Afr Namb
Eur Neth
CAC Nica
Afr Nigr
Eur Nor
Arb Oman
Atl Orkn
SEA PI
AuA PNGu
Car PR
Ind Paki
Pac Palm
CAP Pan
SAP Per
Pac Phx
Eur Porg
Arb Qat
Asi Rus
Arb SArb
Afr SAfr
Atl SGeo
Atl SOrk
Atl SShe
Afr Saha
Pac Sam
Eur Scot
Huh Sene
Atl Shet
SEA Sing
Med Slov
Pac Soc
AuA Solm
Afr Soma
Eur Spa
Ind SriL
Car StBar
Car StCrx
Pac SCrz
Car StLuc
Car StThm
Car StVin
SAC Surn
Atl Sval
Pac Tahi
Asi Taiw
Afr Tanz
Aua Tasm
SEA Thi
Car Tobag
Afr Togo
Pac Toke
Pac Tong
Car Trin
Pac Tua
Pac Tub
Med Tuni
Car Turks
Arb UAE
SAA Urug
Pac Vanu
SAC Venz
SEA Viet
Car Virgn
#Eur Wal
Afr Yem
Med Yug
Afr Zir
*END*

ABBREVIATION_LIST
# The abbreviation list is used to assign abbreviated names to long names.
# As things evolved, it served other uses as well as you will see.
# Note: Only the FIRST occurance of an abbreviation of a given type will be
#   displayed by the station locator menus.  This lets us do aliases easily.
# Field 1: Type of entry (REGION, COUNTRY, STATE)
# Field 2: Abbreviation (no blanks)
# Rest of line: Long form of abbreviation
REGION NAA N. America, Atlantic
REGION NAP N. America, Pacific
REGION NAG N. America, Gulf
REGION CAC Cen. America, Caribbean
REGION CAP Cen. America, Pacific
REGION SAA S. America, Atlantic
REGION SAP S. America, Pacific
REGION SAC S. America, Caribbean
REGION Car Caribbean Islands
REGION Pac Pacific Islands
REGION Atl Atlantic Islands
REGION Eur Europe
REGION Afr Africa
REGION Asi Asia
#REGION Arb Arabia
REGION Arb Middle East
REGION Ind Indian Ocean
REGION SEA South East Asia
REGION Med Mediterranean
REGION AuA Austral-Asia
REGION Ant Antarctica
# The following entries are not referenced anywhere else, just here to make it
# easier to group related islands into regions and not worry about countries.
#REGION BaS Barents Sea
#REGION WhS White Sea
REGION NTS Northern Seas

COUNTRY US    US
COUNTRY US    USA
COUNTRY US    U.S.A
COUNTRY Alb   Albania
COUNTRY Alg   Algeria
COUNTRY Ang   Angola
COUNTRY Ant   Antarctica
COUNTRY Antg  Antigua
COUNTRY Arab  Middle East (general)
COUNTRY Arab  Arabia
COUNTRY Arg   Argentina
COUNTRY AsiM  Asia Minor
COUNTRY Aus   Australia
COUNTRY Azor  Azores
COUNTRY Bahm  Bahamas
COUNTRY Bahr  Bahrain
COUNTRY Bngl  Bangladesh
COUNTRY Barb  Barbados
COUNTRY Belg  Belgium
COUNTRY Belz  Belize
COUNTRY Berm  Bermuda
COUNTRY Bsmk  Bismarck Archipelago
COUNTRY Bona  Bonaire
COUNTRY Brz   Brazil
COUNTRY Burm  Burma
COUNTRY CVrd  Cape Verde
COUNTRY Caic  Caicos
COUNTRY Camb  Cambodia
COUNTRY Came  Cameroon
COUNTRY Can   Canada
COUNTRY Canr  Canary Islands
COUNTRY Carl  Caroline Islands
COUNTRY Chin  China
COUNTRY Chl   Chile
COUNTRY Chrs  Christmas Island
COUNTRY Coco  Cocos Islands
COUNTRY Col   Colombia
COUNTRY Cong  Congo
COUNTRY Cook  Cook Islands
COUNTRY CosR  Costa Rica
COUNTRY Croa  Croatia
COUNTRY Cuba  Cuba
COUNTRY Cura  Curacao
COUNTRY Cyp   Cyprus
COUNTRY Den   Denmark
COUNTRY Djib  Djibouti
COUNTRY Domi  Dominica
COUNTRY DomR  Dominican Republic
COUNTRY Estr  Easter Island
COUNTRY Ecu   Ecuador
COUNTRY Egy   Egypt
COUNTRY Ell   Ellice Islands
COUNTRY ElSa  El Salvador
COUNTRY Eng   England
COUNTRY Erit  Eritrea
COUNTRY Faer  Faeroe Islands
COUNTRY Faer  Faroe Islands
COUNTRY Falk  Falkland Islands
COUNTRY Fann  Fanning Island
COUNTRY Fiji  Fiji
COUNTRY Fr    France
COUNTRY FrGu  French Guiana
COUNTRY Gabn  Gabon
COUNTRY Galp  Galapagos
COUNTRY Gamb  Gambia
COUNTRY Ger   Germany
COUNTRY Ghan  Ghana
COUNTRY Gibr  Gibraltar
COUNTRY Gilb  Gilbert Islands
COUNTRY Grc   Greece
COUNTRY Gren  Grenada
COUNTRY Grn   Greenland
COUNTRY Grnd  Grenadines
COUNTRY Guad  Guadeloupe
COUNTRY Guam  Guam
COUNTRY Guat  Guatemala
COUNTRY Guin  Equatorial Guinea
COUNTRY GuinB Guinea-Bissau
COUNTRY GuinB Guinea
COUNTRY Guya  Guyana
COUNTRY HK    Hong Kong
COUNTRY Hait  Haiti
COUNTRY Hond  Honduras
COUNTRY Howl  Howland Island
COUNTRY Icel  Iceland
COUNTRY Indi  India
COUNTRY Indo  Indonesia
COUNTRY Iran  Iran
COUNTRY Iraq  Iraq
COUNTRY Ire   Ireland
COUNTRY Isr   Israel
COUNTRY Itl   Italy
COUNTRY Ivor  Ivory Coast
COUNTRY Jam   Jamaica
COUNTRY Jons  Johnston Island
COUNTRY Jpn   Japan
COUNTRY Keny  Kenya
COUNTRY Kir   Kuril
COUNTRY Kor   Korea
COUNTRY Kuat  Kuwait
COUNTRY Lays  Laysan Island
COUNTRY Leb   Lebanon
COUNTRY Leon  Sierra Leone
COUNTRY Libe  Liberia
COUNTRY Loy   Loyalty Islands
COUNTRY Lyb   Lybia
COUNTRY Mada  Madagascar
COUNTRY Made  Madeira
COUNTRY Mal   Malaysia
COUNTRY Micr  Micronesia
COUNTRY Malt  Malta
COUNTRY Mari  Marianas
COUNTRY Marq  Marquesas
COUNTRY Mars  Marshall Islands
COUNTRY Mart  Martinique
COUNTRY Maur  Mauritania
COUNTRY Mex   Mexico
COUNTRY Midw  Midway Islands
COUNTRY Mona  Monaco
COUNTRY Mor   Morocco
COUNTRY Moza  Mozambique
COUNTRY Mymr  Myanmar
COUNTRY NewC  New Caledonia
COUNTRY NZ    New Zealand
COUNTRY Namb  Namibia
COUNTRY Neth  Netherlands
COUNTRY Nica  Nicaragua
COUNTRY Nigr  Nigeria
COUNTRY Nor   Norway
COUNTRY Oman  Oman
COUNTRY Orkn  Orkney Islands
COUNTRY PI    Philippines
COUNTRY PI    Philippine
COUNTRY PNGu  New Guinea
COUNTRY PNGu  Papua New Guinea
COUNTRY PR    Puerto Rico
COUNTRY Paki  Pakistan
COUNTRY Palm  Palmyra Island
COUNTRY Pan   Panama
COUNTRY Per   Peru
COUNTRY Phx   Phoenix Islands
COUNTRY Porg  Portugal
COUNTRY Qat   Qatar
COUNTRY Rus   Russia
COUNTRY SArb  Saudi Arabia
COUNTRY SAfr  South Africa
COUNTRY SAfr  Southwest Africa
COUNTRY SGeo  South Georgia
COUNTRY SOrk  South Orkneys
COUNTRY SOrk  South Orkney Islands
COUNTRY SShe  South Shetlands
COUNTRY SShe  South Shetland Islands
COUNTRY Saha  Spanish Sahara
COUNTRY Saha  Western Sahara
COUNTRY Sam   Samoa
COUNTRY Scot  Scotland
COUNTRY Sene  Senegal
COUNTRY Shet  Shetland Islands
COUNTRY Sing  Singapore
COUNTRY Slov  Slovenia
COUNTRY Soc   Society Islands
COUNTRY Solm  Solomon Islands
COUNTRY Soma  Somalia
COUNTRY Spa   Spain
COUNTRY SriL  Sri Lanka
COUNTRY StBar St. Barthelemy
COUNTRY StCrx St. Croix
COUNTRY StCrx St Croix
COUNTRY SCrz  Santa Cruz Islands
COUNTRY StLuc St. Lucia
COUNTRY StLuc Sta. Lucia
COUNTRY StThm Saint Thomas
COUNTRY StThm St. Thomas
COUNTRY StVin St. Vincent
COUNTRY Surn  Surinam
COUNTRY Surn  Suriname
COUNTRY Sval  Svalbard
COUNTRY Tahi  Tahiti
COUNTRY Taiw  Taiwan
COUNTRY Tanz  Tanzania
COUNTRY Tasm  Tasmania
COUNTRY Thi   Thailand
COUNTRY Tobag Tobago
COUNTRY Togo  Togo
COUNTRY Toke  Tokelau Islands
COUNTRY Tong  Tonga
COUNTRY Trin  Trinidad
COUNTRY Tua   Tuamotu
COUNTRY Tub   Tubuai or Austral Islands
COUNTRY Tuni  Tunesia
COUNTRY Tuni  Tunisia
COUNTRY Turks Turks
COUNTRY UAE   U.A.E.
COUNTRY Urug  Uruguay
COUNTRY Vanu  Vanuatu
COUNTRY Venz  Venezuela
COUNTRY Viet  Vietnam
COUNTRY Virgn Virgin Islands
COUNTRY Yem   Yemen
COUNTRY Yug   Yugoslavia
COUNTRY Zir   Zaire

STATE ME   Maine
STATE NH   New Hampshire
STATE MA   Massachusetts
STATE CT   Connecticut
STATE RI   Rhode Island
STATE NY   New York
STATE NJ   New Jersey
STATE DE   Delaware
STATE PA   Pennsylvania
STATE MD   Maryland
STATE DC   D.C.
STATE VA   Virginia
STATE NC   North Carolina
STATE SC   South Carolina
STATE GA   Georgia
STATE AL   Alabama
STATE FL   Florida
STATE MS   Mississippi
STATE LA   Louisiana
STATE TX   Texas
STATE CA   California
STATE OR   Oregon
STATE WA   Washington
STATE AK   Alaska
STATE HI   Hawaii

STATE BC   British Columbia
STATE Qbc  Quebec
STATE Qbc  Qubec
STATE NovS Nova Scotia
STATE Newf Newfoundland
STATE Labr Labrador
STATE Newb New Brunswick
STATE Nun  Nunavut
STATE Nun  Nunavut/NWT
#STATE Marit Maritimes
STATE NWT  Northwest Territories
STATE Ont  Ontario
STATE Man  Manitoba

STATE BCS  Baja California
STATE BCS  B.C.S.
STATE BCS  B.C., MEXICO
#STATE Son  Sonora
#STATE Col  Colima
#STATE Jal  Jalisco
#STATE Sin  Sinaloa

# Start of fixups to get around incognastities in the data
# OTHER will normally be aliases
OTHER AK   Prince of Wales
OTHER Arg  Vancouver, Argentina
OTHER Atl  Ascension Island
OTHER Atl  James Bay, St. Helena
OTHER Atl  Saint Pierre et Miquelon
OTHER Atl  Santo Antonio, Principe
OTHER SC   St. Helena Island, Beaufort River
OTHER Atl  St. Helena Island
OTHER Atl  Trindade
OTHER Atl  Trinidade
OTHER Atl  Tristan da Cunha
OTHER AuA  Admiralty Islands
OTHER AuA  Coral Sea
OTHER AuA  Endeavour Strait
OTHER AuA  LESSER ISLANDS, Detached Islands
OTHER AuA  Tasman Sea
OTHER AuA  Torres Strait
OTHER BC   Powell River (Strait of Georgia), British Columbia
OTHER Bahm Nassau, New Providence Island, Bahamas
OTHER Berm Great Sound, Ireland Island, Bermuda
OTHER Berm Ireland Island, Bermuda Islands
OTHER CA   Berkeley Yacht Harbor
OTHER CA   Carquinez Strait
OTHER CA   Dumbarton Bridge
OTHER CA   Little Coyote Point
OTHER CA   New York Slough
OTHER CA   Oyster Point
OTHER CA   SAN FRANCICO BAY
OTHER CA   Sacramento River
OTHER CA   San Mateo Bridge
OTHER CA   San Pablo Bay
OTHER CA   Suisun Bay
OTHER CA   Trinidad hrbr
OTHER CA   La Jolla, Pacific Ocean, CA
OTHER Can  index number:
OTHER Carl Ant Islands (Tauenai Ch)
OTHER Carl Hall Isls
OTHER Carl Ifalik Atoll
OTHER Carl Kusale Isl
OTHER Carl Lamotrek Atoll
OTHER Carl Losap Atoll
OTHER Carl Marcus Island
OTHER Carl Namoluk Atoll
OTHER Carl Namonuito Atoll
OTHER Carl Ngulu Islands
OTHER Carl Nomoi Isls
OTHER Carl Oroluk Lagoon
OTHER Carl Palau
OTHER Carl Ponape Isl
OTHER Carl Pulap Atoll
OTHER Carl Truk Isls
OTHER Carl Ulithi Islands
OTHER Carl Wake Island
OTHER Carl Woleai Islands
OTHER Carl Yap Isl
OTHER Chin Gulfs of Liaotung & Pohai
OTHER Chin Hainan Island
OTHER Cook Aitutaki
OTHER Cook Rarotonga
OTHER Cura Schottegat, Curaao
OTHER DC   Fort Washington
OTHER DC   Washington National Airport
OTHER DC   Washington, DC
OTHER DC   Washington, D.C.
OTHER DC   Washington, Washington Channel
OTHER Egy  Gulf of Suez
OTHER Eng  Wales
OTHER Eng  Isle of Man
OTHER Estr Easter Island
OTHER FL   Miami Harbor Entrance
OTHER FL   St. Andrew Bay
OTHER FL   Virginia Key, Bear Cut, Florida
OTHER FL   Naples, Gulf Of Mexico, FL
OTHER FL   Clearwater Beach, Gulf Of Mexico, FL
OTHER FL   Cedar Key, Gulf Of Mexico, FL
OTHER FL   Panama City Beach, Gulf Of Mexico, FL
OTHER FL   Virginia Key, Biscayne Bay, FL
OTHER Fiji Tuvalu
OTHER Fr   Channel Islands
OTHER Fr   Deauville, France
OTHER Guam Guam (Apra Harbor)
OTHER Guam Apra Harbor, GU
OTHER Guam Pago Bay, GU
OTHER HI   East Isl, French Frig Shoals
OTHER HI   Honolulu
OTHER HI   Kahoolawe
OTHER HI   Kauai
OTHER HI   Lanai
OTHER HI   Maui
OTHER HI   Molokai
OTHER HI   Nonopapa, Niihau Isl
OTHER HI   Oahu
OTHER Ind  Andaman
OTHER Ind  Kerguelen
OTHER Ind  LESSER ISLANDS
OTHER Ind  Mayotte
OTHER Ind  Reunion
OTHER Indi Minicoy
OTHER Indo Alor Island
OTHER Indo Bali
OTHER Indo Borneo
OTHER Indo Celebes
OTHER Indo Flores Island
OTHER Indo Java
OTHER Indo Lombok
OTHER Indo Molukka
OTHER Indo Sumatra
OTHER Indo Sumba
OTHER Indo Sumbawa
OTHER Indo Tanimbar
OTHER Indo Timor
OTHER Iran Jask Bay, Gulf of Oman
OTHER Ire  EIRE, East Coast
OTHER Ire  Eire
OTHER Isr  Tel Aviv-Yafo
OTHER Itl  Corsica
OTHER Itl  Sardinia
OTHER Ivor Abidjan, Cote D'Ivoire
OTHER Jpn  Hokkaido
OTHER Jpn  Honshu
OTHER Jpn  Nanpo Shoto
OTHER Jpn  Shikoku
OTHER Kir  Chishima Retto
OTHER Kir  Kurile
OTHER Kor  Japan Sea
OTHER Libe Togo
OTHER MA   Buzzards Bay
OTHER MA   MASSACHUSSETS
OTHER MA   Martha's Vineyard
OTHER MA   Nantucket
OTHER MD   Chesapeake Bay, Eastern Shore
OTHER MD   Corsica River, Maryland
OTHER VA   Potomac River, Virginia
OTHER MD   Potomac River
OTHER MD   Severn River, Annapolis
OTHER ME   New England
OTHER Mex  Colima
OTHER Mex  Jalisco
OTHER Mex  Sinaloa
OTHER Mex  Sonora
OTHER Micr F.S.M.
OTHER Micr Lele Harbor, Kusale Isl
OTHER NJ   Washington Canal
OTHER NWT  Baffin Bay
OTHER NWT  Davis Strait, W. Side
OTHER NWT  Hudson Strait & Bay
OTHER NY   George Washington Bridge
OTHER NY   Hempstead Bay
#OTHER NY   Port Washington
OTHER NY   Manhasset Bay
OTHER Nor  Spitsbergen
OTHER NovS Bay of Fundy
OTHER NovS Islands, Gulf of St Lawrence
OTHER NovS Prince Edward Island
OTHER NovS Sonora, St Mary Rvr
OTHER NovS Sonora, St. Mary River
OTHER NTS Barents Sea
OTHER NTS White Sea
OTHER Nun  Tuktoyaktuk, NWT
OTHER PNGu Rabaul
OTHER Pac  Caroline Island
OTHER Pac  Gambier Islands
OTHER Tong Niue Island
OTHER Pac  Penrhyn (Tongareva) Island
OTHER Pac  Pukapuka
OTHER Pac  Raoul or Sunday Island
OTHER Mex  Revillagigedo Islands
OTHER Pac  Rotumah Island
OTHER Pac  Suvarov Island
OTHER Pac  Wallis
OTHER Qat  Ad Dawhah, Qatar
OTHER Qbc  Sept Iles, Quebec
OTHER Rus  Gulf of Amur
OTHER Rus  Gulf of Tartary
OTHER Rus  KARA SEA
OTHER Rus  KARA STRAIT
OTHER Rus  Karafuto, Sakhalin Isl
OTHER Rus  NOVAYA ZEMLYA
OTHER Rus  Sea of Okhotsk
OTHER Rus  YUGORSKI STRAIT
OTHER SGeo South Georgia
OTHER Scot Hebrides
OTHER Sam  Pago Pago, AS
OTHER TX   Galveston Bay
OTHER TX   Galveston Pleasure Pier, Gulf Of Mexico, TX
OTHER TX   Corpus Christi, Gulf Of Mexico, TX
OTHER Taiw (Pescadores Islands)
OTHER Taiw P'eng-hu Ch'un-tao
OTHER Togo Lome, Togo
OTHER Tong Neiafu, Vava`u Group, Tonga
OTHER Tua  Makemo Atoll, Tuamotu Archipelago
OTHER Tub  Austral Islands
OTHER UAE  Fujayrah
OTHER VA   Chesapeake Bay, W. Shore cont.
OTHER VA   Hampton Roads
OTHER VA   Oregon Inlet
OTHER VA   Southern Shore
OTHER VA   Scotland, James River, VA
OTHER Vanu Port-Vila, Vanuatu
OTHER WA   Strait of Georgia, Washington
OTHER WA   Strait of Georgia, Wa
OTHER WA   La Push, Quillayute River, WA
OTHER WA   Strait Of Juan De Fuca, WA
OTHER Jons Johnston Atoll
OTHER BC   Wales Island (Cannery)

# Now things that cause us to ignore a line for country/state candidacy
OTHER IGNORE # This entry was
OTHER IGNORE # donated by
OTHER IGNORE # that Dean found
OTHER IGNORE # that I found
OTHER IGNORE # Data from
OTHER IGNORE # ---------
OTHER IGNORE # ENGLISH
OTHER IGNORE # METRIC
OTHER IGNORE # !units
OTHER IGNORE # Some machines
OTHER IGNORE # This data set was submitted
OTHER IGNORE # (scipur@collegenotre-dame.qc
OTHER IGNORE # The source was the Table
OTHER IGNORE # from the Service Hydrographique
OTHER IGNORE # B.P. 426, 29275 Brest Cedex.
OTHER IGNORE Jean Pierre
OTHER IGNORE # partially derived from
OTHER IGNORE Paul Getman
OTHER IGNORE CANADA V0N 2P0
OTHER IGNORE Gulf of California
OTHER IGNORE (See Delaware Rvr)
OTHER IGNORE Strait of Georgia
OTHER IGNORE Centreville Landing, Corsica Rvr
OTHER IGNORE China Bakir (Old Lighthouse)
OTHER IGNORE Puerto Henry, Golfo Trinidad
OTHER IGNORE Bahia India, Seno Ano Nuevo
OTHER IGNORE Port Purvis, Florida Isl
OTHER IGNORE Nususonga, New Georgia Isl
OTHER IGNORE Ireland Island

#Subordinate stations to skip altogether since there are now ref's for these.
OTHER SKIP   Harrington Harbor
OTHER SKIP   Havre St. Pierre
OTHER SKIP   Mingan
OTHER SKIP   Anticosti Island: Heath Point
OTHER SKIP   Anticosti Island: Southwest Point
OTHER SKIP   Anticosti Island: Ellis Bay
OTHER SKIP   Moisie Bay
OTHER SKIP   Sept Isles
OTHER SKIP   Cawee Islands
OTHER SKIP   Ste. Anne des Monts
OTHER SKIP   Cap Chat
OTHER SKIP   Pointe des Monts
OTHER SKIP   Matane
OTHER SKIP   Metis-sur-Mer
OTHER SKIP   Betsiamites River
OTHER SKIP   Father Point
OTHER SKIP   Old Bic Harbor
OTHER SKIP   Tadoussac, Saguenay Rvr
OTHER SKIP   Chicoutimi, Saguenay Rvr
OTHER SKIP   Brandypot Islands
OTHER SKIP   Murray Bay
OTHER SKIP   Pointe aux Orignaux
OTHER SKIP   Ile aux Coudres
OTHER SKIP   L'Islet
OTHER SKIP   Beaujeu Channel
OTHER SKIP   Grosse Ile
OTHER SKIP   Berthier
OTHER SKIP   St. Laurent d'Orleans
#OTHER SKIP   Quebec
OTHER SKIP   St. Nicolas
OTHER SKIP   St. Augustin
OTHER SKIP   Ste. Croix
OTHER SKIP   Pointe Platon
OTHER SKIP   Grondines
OTHER SKIP   Cap a la Roche
OTHER SKIP   Batiscan
OTHER SKIP   Champlain
OTHER SKIP   Trois Rivieres
OTHER SKIP   Goodnews Bay Entrance
OTHER SKIP   Carter Spit
OTHER SKIP   Eek Channel, off Quinhagak
OTHER SKIP   Warehouse Creek Entrance
OTHER SKIP   Kuskokwat Creek Entrance
OTHER SKIP   Popokamute
OTHER SKIP   Apokak Creek Entrance
OTHER SKIP   Bethel
*END*

REGION_FIXUP
# REGION fixups for Countries/states bordering two seas.
# First field is combo sort ID (with '?' anywhere you want)
# Second and Third fields are +(NE) and -(SW) sort IDs from line(s)
# Remainder of line is pairs of lon lat to determine zone (max 5 pairs)
# Note: Lon and Lat values are decimal degrees (e.g. 8.5 = 8 deg, 30 min)
NA?:US:FL:  NAA:US:FL: NAG:US:FL: -82.75 31 -80.16 25.66
NA?:Mex::   NAG:Mex::  NAP:Mex::    -110 32    -99 18    -92 18
CA?:Guat::  CAC:Guat:: CAP:Guat::    -93 19    -84 11
CA?:Hond::  CAC:Hond:: CAP:Hond::    -93 19    -84 11
CA?:Nica::  CAC:Nica:: CAP:Nica::    -93 19    -84 11
CA?:CosR::  CAC:CosR:: CAP:CosR::    -85 11    -81  8
#Afr:Egy::   Med:Egy::  Red:Egy::      20 30     35 20
Afr:Mor::   Med:Mor::  Afr:Mor::      -6 37     -6 25
Eur:Fr::    Med:Fr::   Eur:Fr::        7 53      0 40
Eur:Spa::   Med:Spa::  Eur:Spa::       2 45   -5.3 35
Asi:Rus::   Asi:Rus::  NTS:Rus::      90 85     90 35
CA?:Pan::   CAC:Pan::  CAP:Pan::     -83 8     -81  8    -79 9   -76 7
NA?:Can::   NAA:Can::  NAP:Can::  -105 90  -105 0
*END*

AUTO_FIXUP
# This one took some time.  It is a master typo fix-up list for timezones and
# positions (Longitude/Latitude). I hope it is reasonably obvious how it works.
# The only real gotcha is the LONLAT fixup, sort ID.  This is pre-REGION_FIXUP
# which means that the zone ID in the idxerror.txt file may not be the same as
# the program is looking for, so be carefull.
TIMEZONE Atl:          -30:00  -3:00
TIMEZONE NAA:Can:NWT   -30:00  -3:00
TIMEZONE Eur:Fr:         0:06   1:00
TIMEZONE Pac:           -0:06 -10:00
TIMEZONE Pac:           -0:07 -11:00
TIMEZONE NAA:Can:       -0:02  -4:00
TIMEZONE NAA:US:NY:     -0:03  -5:00
TIMEZONE NAG:US:LA:     -0:36  -6:00
TIMEZONE Car:Jam::      -0:03  -5:00
TIMEZONE NAP:US:CA:     -0:05  -8:00
TIMEZONE NAP:US:AK:     -0:54  -9:00
TIMEZONE Asi:Kor::       0:05   9:00
TIMEZONE SEA:Indo::      0:05   8:00
TIMEZONE SEA:PI::        0:05   8:00
TIMEZONE Afr:Tanz::     30:00   3:00
TIMEZONE Asi:Rus::      -0:54  -9:00
TIMEZONE Ind:::         30:00   3:00
LONLAT NAP:US:AK: -131.6333   55.3333 Ketchikan
LONLAT Med:Itl::    18.5      40.15   Golfo di Taranto: Otranto
LONLAT Med:Itl::    12.3      45.2333 Adriatic: Chioggia
LONLAT Med:Grc::    22.85     38.8    Dhiavlos Knimidhos
LONLAT Med:Yug::    14.9      44.9833 Senj
LONLAT NAA:US:SC:  -79.25     33.1333 North Santee River Inlet
LONLAT NAA:US:NH:  -70.7167   43.05   Portsmouth Harbor: Jaffrey Point
LONLAT NAA:US:MA:  -70.3      41.3333 Muskeget Island, N.Side
LONLAT NAA:US:ME:  -70.0167   43.7333 South Harpswell, Potts Hrb
LONLAT NAP:US:CA: -122.3833   37.7667 Potrero Point
LONLAT SEA:PI::    123.65     13.9333 Sisiran Bay
LONLAT NTS:::       38.45     64.7833 Unskaya Inlet
LONLAT Asi:Rus::   140.8833   51.6167 Taba Bay
LONLAT Asi:Rus::   141.2833   52.6667 Cape Dzhaore
LONLAT Asi:Rus::   142.8167   47.4167 Sakayehama
LONLAT NAP:Mex::  -104.33     19.05   Manzanillo
LONLAT Afr:Keny::   39.6      -5.2333 Mesale Island, Pemba Isl
LONLAT Pac:Tua::  -147.7333  -14.95   Rahiroa (Rangiroa) Island
*END*